/**
* Script: main.js
* Written by: Radnen
* Updated: 3/7/2011
**/

if (GetTime() < 0) {
	Abort("You need to restart your computer. The game clock is receiving invalid data from your processor.\n\n"+
	"\n\n - Thank you.\n");
}

RequireScript("RadLib/radlib.js");

var LoadScreen = LoadImage("loadscreen.png");
Resources.loadRenderer = function() {
	LoadScreen.transformBlit(0, 0, GetScreenWidth(), 0, GetScreenWidth(), GetScreenHeight(), 0, GetScreenHeight());
}

Resources.loadAll();

if (SW != 1440) {
	var resizeimg = Resources.images.testoverlay.createSurface();
	Resources.images.testoverlay = resizeimg.rescale(SW, SH).createImage();
	resizeimg = Resources.images.menubg.createSurface();
	Resources.images.menubg = resizeimg.rescale(SW, SH).createImage();
	resizeimg = Resources.images.titlescreen.createSurface();
	Resources.images.titlescreen = resizeimg.rescale(SW, SH).createImage();
}

RequireScript("RadGui/radgui.js");
RequireScript("engine/game_engine.js");
RequireScript("ui/textstate.js");
RequireScript("ui/optionsstate.js");
RequireScript("ui/shopstate.js");
RequireScript("ui/loadstate.js");
RequireScript("ui/savestate.js");
RequireScript("ui/landstate.js");
RequireScript("ui/queststate.js");
RequireScript("ui/getqueststate.js");
RequireScript("ui/questfinishstate.js");
RequireScript("ui/repairstate.js");
RequireScript("ui/yesnostate.js");
RequireScript("ui/inventorystate.js");

StateManager.preRender = function() {
	Resources.images.menubg.blit(0, 0);
}

System.menuWindow = Resources.windowstyles.MessageBox;
System.highlight = Resources.windowstyles.WinSelector;
System.textFont = Resources.fonts.main;
System.windowFont = Resources.fonts.windowtext;
System.btnup = Resources.windowstyles.btnup;
System.btndn = Resources.windowstyles.btndn;
System.btnov = Resources.windowstyles.btnov;

Cursor.__defineGetter__("screenX", function() {
	return this.x-Camera.x;
});

Cursor.__defineGetter__("screenY", function() {
	return this.y-Camera.y;
});

var gamemenu = new MenuState("GameMenu", SW/2-60, SH/2-60, 120, 120);
gamemenu.addItem("Return", function() {
	gamemenu.hide();
});

gamemenu.addItem("Save Game", function() {
	var savemenu = new SaveState().show();
});

gamemenu.addItem("Load Game", function() {
	var loadmenu = new LoadState().show();
});
gamemenu.addItem("Options", function() {
	var options = new OptionState().show();
});
gamemenu.addItem("Exit", function() {
	var yesno = new YesNoState("Are you sure you want to quit?");
	yesno.onOkay.add(function() {
		Exit();
	});
	yesno.show();
});

var menustate = new MenuState("MainMenu", SW/2-60, SH/2-48, 120, 96);
menustate.preRender = function() {
	Resources.images.titlescreen.blit(0, 0);
}
menustate.addItem("New Game", function() {
	menustate.hide();
	NewGame();
});
menustate.addItem("Load Game", function() {
	var ls = new LoadState().show();
});
menustate.addItem("Options", function() {
	var options = new OptionState().show();
});
menustate.addItem("Quit Game", Exit);

function game()
{
	Genesis.loadOptions();
	StarChart.generateStarPoints();
	//SetFrameRate(60);
	Audio.play(Resources.music.theme);
	menustate.show();
	Audio.play(Resources.music.theme);
	
	StateManager.execute();
}

function ShowHelp() {
		var help1 = new TextState("Welcome to the universe cadet! You can move with the arrow keys and "+
		"select planets and other ships with the mouse. Selecting ships can be important for combat. Press "+
		"the spacebar to fire your main guns, and ctrl to fire your secondary.");
		var help2 = new TextState("You can hyperspace to other systems by pressing TAB to bring up the "+
		"Hyperspace menu. Pressing H will commence a hyperspace jump After clicking on the destination with "+
		"the mouse. Pressing M will bring up the system map in case you get lost!");
		var help3 = new TextState("You can land on a planet by slowing down and then pressing L when it "+
		"tells you that you can land. At a planet you can repair your ship, get quests, and in the final "+
		"version go to the shop/hangar to purchase/upgrade your current ship.");
		var help4 = new TextState("In this demo version you can press 1-6 to cycle through the 6 playable ships. "+
		"The ships will auto-equip their default weapons. Have fun!\n\nYou can press F1 to repeat this anytime.");
		
		help4.show();
		help3.show();
		help2.show();
		help1.show();
}

function NewGame(file) {
	Audio.play(Resources.music.abyss);
	Audio.playBgm(Resources.music.dronescape);

	if (!file) {
		Genesis.player = new Player();
		Genesis.loadGameWorld("Sol");
		ShowHelp();
	}
	else Genesis.load(file);
	
	while(true) {
		Genesis.updateGameWorld();
		StateManager.execute();
		Cursor.draw();
		FlipScreen();
	}
}

function GetDist(x1, y1, x2, y2) {
	var xx = x1 - x2;
	var yy = y1 - y2;
	return Math.sqrt(xx*xx + yy*yy);
}